@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.CacheConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cache configurations.
 * @property maxStorageUsage Max storage usage in megabytes.
 * @property retentionPeriod Retention period in minutes.
 */
public data class CacheConfigurationArgs(
    public val maxStorageUsage: Output<Int>? = null,
    public val retentionPeriod: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.CacheConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.CacheConfigurationArgs =
        com.pulumi.azurenative.monitor.inputs.CacheConfigurationArgs.builder()
            .maxStorageUsage(maxStorageUsage?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheConfigurationArgs].
 */
@PulumiTagMarker
public class CacheConfigurationArgsBuilder internal constructor() {
    private var maxStorageUsage: Output<Int>? = null

    private var retentionPeriod: Output<Int>? = null

    /**
     * @param value Max storage usage in megabytes.
     */
    @JvmName("cikomvlxrntxyixd")
    public suspend fun maxStorageUsage(`value`: Output<Int>) {
        this.maxStorageUsage = value
    }

    /**
     * @param value Retention period in minutes.
     */
    @JvmName("yeqbvtbefpnmgxsy")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Max storage usage in megabytes.
     */
    @JvmName("shihamnesgvseghu")
    public suspend fun maxStorageUsage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxStorageUsage = mapped
    }

    /**
     * @param value Retention period in minutes.
     */
    @JvmName("ptqvwbmgtvhpvmir")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    internal fun build(): CacheConfigurationArgs = CacheConfigurationArgs(
        maxStorageUsage = maxStorageUsage,
        retentionPeriod = retentionPeriod,
    )
}
