@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ConcurrencyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Concurrent publishing configuration.
 * @property batchQueueSize Size of the queue for log batches.
 * @property workerCount Number of parallel workers processing the log queues.
 */
public data class ConcurrencyConfigurationArgs(
    public val batchQueueSize: Output<Int>? = null,
    public val workerCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ConcurrencyConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ConcurrencyConfigurationArgs =
        com.pulumi.azurenative.monitor.inputs.ConcurrencyConfigurationArgs.builder()
            .batchQueueSize(batchQueueSize?.applyValue({ args0 -> args0 }))
            .workerCount(workerCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConcurrencyConfigurationArgs].
 */
@PulumiTagMarker
public class ConcurrencyConfigurationArgsBuilder internal constructor() {
    private var batchQueueSize: Output<Int>? = null

    private var workerCount: Output<Int>? = null

    /**
     * @param value Size of the queue for log batches.
     */
    @JvmName("mqyfwkxmgqsugwrn")
    public suspend fun batchQueueSize(`value`: Output<Int>) {
        this.batchQueueSize = value
    }

    /**
     * @param value Number of parallel workers processing the log queues.
     */
    @JvmName("guggafoltdxuqfcv")
    public suspend fun workerCount(`value`: Output<Int>) {
        this.workerCount = value
    }

    /**
     * @param value Size of the queue for log batches.
     */
    @JvmName("ujvdwqvbgmfjfege")
    public suspend fun batchQueueSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchQueueSize = mapped
    }

    /**
     * @param value Number of parallel workers processing the log queues.
     */
    @JvmName("whatstwwyepedevt")
    public suspend fun workerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerCount = mapped
    }

    internal fun build(): ConcurrencyConfigurationArgs = ConcurrencyConfigurationArgs(
        batchQueueSize = batchQueueSize,
        workerCount = workerCount,
    )
}
