@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ExporterArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.ExporterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Exporter Info.
 * @property azureMonitorWorkspaceLogs Azure Monitor Workspace Logs specific configurations.
 * @property name The name of exporter.
 * @property tcp TCP based exporter. Used for pipelineGroup exporter.
 * @property type The type of exporter.
 */
public data class ExporterArgs(
    public val azureMonitorWorkspaceLogs: Output<AzureMonitorWorkspaceLogsExporterArgs>? = null,
    public val name: Output<String>,
    public val tcp: Output<TcpExporterArgs>? = null,
    public val type: Output<Either<String, ExporterType>>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ExporterArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ExporterArgs =
        com.pulumi.azurenative.monitor.inputs.ExporterArgs.builder()
            .azureMonitorWorkspaceLogs(
                azureMonitorWorkspaceLogs?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .tcp(tcp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExporterArgs].
 */
@PulumiTagMarker
public class ExporterArgsBuilder internal constructor() {
    private var azureMonitorWorkspaceLogs: Output<AzureMonitorWorkspaceLogsExporterArgs>? = null

    private var name: Output<String>? = null

    private var tcp: Output<TcpExporterArgs>? = null

    private var type: Output<Either<String, ExporterType>>? = null

    /**
     * @param value Azure Monitor Workspace Logs specific configurations.
     */
    @JvmName("gayaajydikydxajk")
    public suspend fun azureMonitorWorkspaceLogs(`value`: Output<AzureMonitorWorkspaceLogsExporterArgs>) {
        this.azureMonitorWorkspaceLogs = value
    }

    /**
     * @param value The name of exporter.
     */
    @JvmName("kxfkvluqropgytmf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value TCP based exporter. Used for pipelineGroup exporter.
     */
    @JvmName("whktcnsuhbemywxv")
    public suspend fun tcp(`value`: Output<TcpExporterArgs>) {
        this.tcp = value
    }

    /**
     * @param value The type of exporter.
     */
    @JvmName("fnnqvwalsplofaji")
    public suspend fun type(`value`: Output<Either<String, ExporterType>>) {
        this.type = value
    }

    /**
     * @param value Azure Monitor Workspace Logs specific configurations.
     */
    @JvmName("rvborbtstnopxciv")
    public suspend fun azureMonitorWorkspaceLogs(`value`: AzureMonitorWorkspaceLogsExporterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorWorkspaceLogs = mapped
    }

    /**
     * @param argument Azure Monitor Workspace Logs specific configurations.
     */
    @JvmName("jfcbsnivivmyhgmi")
    public suspend fun azureMonitorWorkspaceLogs(argument: suspend AzureMonitorWorkspaceLogsExporterArgsBuilder.() -> Unit) {
        val toBeMapped = AzureMonitorWorkspaceLogsExporterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorWorkspaceLogs = mapped
    }

    /**
     * @param value The name of exporter.
     */
    @JvmName("jkmmkurhbuaneoqq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value TCP based exporter. Used for pipelineGroup exporter.
     */
    @JvmName("ysdimryfrsvraqbs")
    public suspend fun tcp(`value`: TcpExporterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    /**
     * @param argument TCP based exporter. Used for pipelineGroup exporter.
     */
    @JvmName("odapswloaciagarh")
    public suspend fun tcp(argument: suspend TcpExporterArgsBuilder.() -> Unit) {
        val toBeMapped = TcpExporterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcp = mapped
    }

    /**
     * @param value The type of exporter.
     */
    @JvmName("ddjrnkwnnhjtptce")
    public suspend fun type(`value`: Either<String, ExporterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of exporter.
     */
    @JvmName("rimeglafamhxtabp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExporterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of exporter.
     */
    @JvmName("fpebhbudmrmxxynk")
    public fun type(`value`: ExporterType) {
        val toBeMapped = Either.ofRight<String, ExporterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExporterArgs = ExporterArgs(
        azureMonitorWorkspaceLogs = azureMonitorWorkspaceLogs,
        name = name ?: throw PulumiNullFieldException("name"),
        tcp = tcp,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
