@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ExtendedLocationArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.ExtendedLocationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The extended location info.
 * @property name The name of extended location.
 * @property type The type of extended location.
 */
public data class ExtendedLocationArgs(
    public val name: Output<String>,
    public val type: Output<Either<String, ExtendedLocationType>>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ExtendedLocationArgs =
        com.pulumi.azurenative.monitor.inputs.ExtendedLocationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExtendedLocationArgs].
 */
@PulumiTagMarker
public class ExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, ExtendedLocationType>>? = null

    /**
     * @param value The name of extended location.
     */
    @JvmName("kciuguapcexrrvdk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of extended location.
     */
    @JvmName("vcefcebhexpdyklt")
    public suspend fun type(`value`: Output<Either<String, ExtendedLocationType>>) {
        this.type = value
    }

    /**
     * @param value The name of extended location.
     */
    @JvmName("fshblguwomyjwuvi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of extended location.
     */
    @JvmName("tdmkivoyuceuroeg")
    public suspend fun type(`value`: Either<String, ExtendedLocationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of extended location.
     */
    @JvmName("jyfjmxuwtrathcbi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExtendedLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of extended location.
     */
    @JvmName("jqrvkinhradhwerc")
    public fun type(`value`: ExtendedLocationType) {
        val toBeMapped = Either.ofRight<String, ExtendedLocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtendedLocationArgs = ExtendedLocationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
