@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.GetPipelineGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineGroupName The name of pipeline group. The name is case insensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPipelineGroupPlainArgs(
    public val pipelineGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.GetPipelineGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.GetPipelineGroupPlainArgs =
        com.pulumi.azurenative.monitor.inputs.GetPipelineGroupPlainArgs.builder()
            .pipelineGroupName(pipelineGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPipelineGroupPlainArgsBuilder internal constructor() {
    private var pipelineGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of pipeline group. The name is case insensitive.
     */
    @JvmName("thbxnbuxxxoqekcb")
    public suspend fun pipelineGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineGroupName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sqqcibfqxpanbqnx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelineGroupPlainArgs = GetPipelineGroupPlainArgs(
        pipelineGroupName = pipelineGroupName ?: throw PulumiNullFieldException("pipelineGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
