@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.NetworkingConfigurationArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.ExternalNetworkingMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Networking configuration for the pipeline group instance.
 * @property externalNetworkingMode External networking mode.
 * @property host The address exposed on the cluster. Example: azuremonitorpipeline.contoso.com.
 * @property routes Networking routes configuration.
 */
public data class NetworkingConfigurationArgs(
    public val externalNetworkingMode: Output<Either<String, ExternalNetworkingMode>>,
    public val host: Output<String>? = null,
    public val routes: Output<List<NetworkingRouteArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.NetworkingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.NetworkingConfigurationArgs =
        com.pulumi.azurenative.monitor.inputs.NetworkingConfigurationArgs.builder()
            .externalNetworkingMode(
                externalNetworkingMode.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .host(host?.applyValue({ args0 -> args0 }))
            .routes(
                routes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkingConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkingConfigurationArgsBuilder internal constructor() {
    private var externalNetworkingMode: Output<Either<String, ExternalNetworkingMode>>? = null

    private var host: Output<String>? = null

    private var routes: Output<List<NetworkingRouteArgs>>? = null

    /**
     * @param value External networking mode.
     */
    @JvmName("wxwdlrtnckhlnnfj")
    public suspend fun externalNetworkingMode(`value`: Output<Either<String, ExternalNetworkingMode>>) {
        this.externalNetworkingMode = value
    }

    /**
     * @param value The address exposed on the cluster. Example: azuremonitorpipeline.contoso.com.
     */
    @JvmName("tuwtqemmklbfveyr")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Networking routes configuration.
     */
    @JvmName("bxaiqvfqptvfnjvc")
    public suspend fun routes(`value`: Output<List<NetworkingRouteArgs>>) {
        this.routes = value
    }

    @JvmName("unuilibijrpjmadc")
    public suspend fun routes(vararg values: Output<NetworkingRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Networking routes configuration.
     */
    @JvmName("qofsmjvqwmnqmwnq")
    public suspend fun routes(values: List<Output<NetworkingRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value External networking mode.
     */
    @JvmName("bgirmxggijxpirsn")
    public suspend fun externalNetworkingMode(`value`: Either<String, ExternalNetworkingMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalNetworkingMode = mapped
    }

    /**
     * @param value External networking mode.
     */
    @JvmName("ittumkapohcspljl")
    public fun externalNetworkingMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExternalNetworkingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalNetworkingMode = mapped
    }

    /**
     * @param value External networking mode.
     */
    @JvmName("mtgwchgwyuoiflno")
    public fun externalNetworkingMode(`value`: ExternalNetworkingMode) {
        val toBeMapped = Either.ofRight<String, ExternalNetworkingMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalNetworkingMode = mapped
    }

    /**
     * @param value The address exposed on the cluster. Example: azuremonitorpipeline.contoso.com.
     */
    @JvmName("qxteixqxuqwumkla")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Networking routes configuration.
     */
    @JvmName("gklaqjoeilyjbvbu")
    public suspend fun routes(`value`: List<NetworkingRouteArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Networking routes configuration.
     */
    @JvmName("xbfmhcivycxnhcnx")
    public suspend fun routes(argument: List<suspend NetworkingRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkingRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Networking routes configuration.
     */
    @JvmName("wvnfpkkehxyqlyrf")
    public suspend fun routes(vararg argument: suspend NetworkingRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkingRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Networking routes configuration.
     */
    @JvmName("aidgixysjcrwylxe")
    public suspend fun routes(argument: suspend NetworkingRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkingRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Networking routes configuration.
     */
    @JvmName("ffgibuxwmwymwtll")
    public suspend fun routes(vararg values: NetworkingRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): NetworkingConfigurationArgs = NetworkingConfigurationArgs(
        externalNetworkingMode = externalNetworkingMode ?: throw
            PulumiNullFieldException("externalNetworkingMode"),
        host = host,
        routes = routes ?: throw PulumiNullFieldException("routes"),
    )
}
