@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.NetworkingRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Networking route configuration.
 * @property path Route path.
 * @property port The port that will be configured externally. If not specified, it will use the port from the receiver definition.
 * @property receiver The name of the previously defined receiver.
 * @property subdomain Route subdomain.
 */
public data class NetworkingRouteArgs(
    public val path: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val `receiver`: Output<String>,
    public val subdomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.NetworkingRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.NetworkingRouteArgs =
        com.pulumi.azurenative.monitor.inputs.NetworkingRouteArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .`receiver`(`receiver`.applyValue({ args0 -> args0 }))
            .subdomain(subdomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkingRouteArgs].
 */
@PulumiTagMarker
public class NetworkingRouteArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var `receiver`: Output<String>? = null

    private var subdomain: Output<String>? = null

    /**
     * @param value Route path.
     */
    @JvmName("pfpqkcorbjgiaach")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The port that will be configured externally. If not specified, it will use the port from the receiver definition.
     */
    @JvmName("iurpmbjupgvkbfgs")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The name of the previously defined receiver.
     */
    @JvmName("quusuqejsvumhofx")
    public suspend fun `receiver`(`value`: Output<String>) {
        this.`receiver` = value
    }

    /**
     * @param value Route subdomain.
     */
    @JvmName("duymjbemwrsncytp")
    public suspend fun subdomain(`value`: Output<String>) {
        this.subdomain = value
    }

    /**
     * @param value Route path.
     */
    @JvmName("jamoxcwwgyrdxdeb")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The port that will be configured externally. If not specified, it will use the port from the receiver definition.
     */
    @JvmName("khqdyfbgwhqbwdrm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The name of the previously defined receiver.
     */
    @JvmName("rqmfioaioabpxesa")
    public suspend fun `receiver`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`receiver` = mapped
    }

    /**
     * @param value Route subdomain.
     */
    @JvmName("uuifcfdddfvbigrc")
    public suspend fun subdomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdomain = mapped
    }

    internal fun build(): NetworkingRouteArgs = NetworkingRouteArgs(
        path = path,
        port = port,
        `receiver` = `receiver` ?: throw PulumiNullFieldException("receiver"),
        subdomain = subdomain,
    )
}
