@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.OtlpReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * OTLP Receiver.
 * @property endpoint OTLP GRPC endpoint definition. Example: 0.0.0.0:<port>.
 */
public data class OtlpReceiverArgs(
    public val endpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.OtlpReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.OtlpReceiverArgs =
        com.pulumi.azurenative.monitor.inputs.OtlpReceiverArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OtlpReceiverArgs].
 */
@PulumiTagMarker
public class OtlpReceiverArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    /**
     * @param value OTLP GRPC endpoint definition. Example: 0.0.0.0:<port>.
     */
    @JvmName("tvbckebtcqvxsgwl")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value OTLP GRPC endpoint definition. Example: 0.0.0.0:<port>.
     */
    @JvmName("mepvtuovmqhnngil")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    internal fun build(): OtlpReceiverArgs = OtlpReceiverArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
    )
}
