@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.PersistenceConfigurationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Persistence options to all pipelines in the instance.
 * @property persistentVolumeName The name of the mounted persistent volume.
 */
public data class PersistenceConfigurationsArgs(
    public val persistentVolumeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.PersistenceConfigurationsArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.PersistenceConfigurationsArgs =
        com.pulumi.azurenative.monitor.inputs.PersistenceConfigurationsArgs.builder()
            .persistentVolumeName(persistentVolumeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PersistenceConfigurationsArgs].
 */
@PulumiTagMarker
public class PersistenceConfigurationsArgsBuilder internal constructor() {
    private var persistentVolumeName: Output<String>? = null

    /**
     * @param value The name of the mounted persistent volume.
     */
    @JvmName("dljjtgbdlriewpte")
    public suspend fun persistentVolumeName(`value`: Output<String>) {
        this.persistentVolumeName = value
    }

    /**
     * @param value The name of the mounted persistent volume.
     */
    @JvmName("vtgjiydsqqwkjjhv")
    public suspend fun persistentVolumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.persistentVolumeName = mapped
    }

    internal fun build(): PersistenceConfigurationsArgs = PersistenceConfigurationsArgs(
        persistentVolumeName = persistentVolumeName ?: throw
            PulumiNullFieldException("persistentVolumeName"),
    )
}
