@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.PipelineArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.PipelineType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Pipeline Info.
 * @property exporters Reference to exporters configured for the pipeline.
 * @property name Name of the pipeline.
 * @property processors Reference to processors configured for the pipeline.
 * @property receivers Reference to receivers configured for the pipeline.
 * @property type The type of pipeline
 */
public data class PipelineArgs(
    public val exporters: Output<List<String>>,
    public val name: Output<String>,
    public val processors: Output<List<String>>? = null,
    public val receivers: Output<List<String>>,
    public val type: Output<Either<String, PipelineType>>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.PipelineArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.PipelineArgs =
        com.pulumi.azurenative.monitor.inputs.PipelineArgs.builder()
            .exporters(exporters.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .processors(processors?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .receivers(receivers.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var exporters: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var processors: Output<List<String>>? = null

    private var receivers: Output<List<String>>? = null

    private var type: Output<Either<String, PipelineType>>? = null

    /**
     * @param value Reference to exporters configured for the pipeline.
     */
    @JvmName("aoaxtvfnlektlrun")
    public suspend fun exporters(`value`: Output<List<String>>) {
        this.exporters = value
    }

    @JvmName("fojewgudmrhvkgdb")
    public suspend fun exporters(vararg values: Output<String>) {
        this.exporters = Output.all(values.asList())
    }

    /**
     * @param values Reference to exporters configured for the pipeline.
     */
    @JvmName("jhlidqrglavblpku")
    public suspend fun exporters(values: List<Output<String>>) {
        this.exporters = Output.all(values)
    }

    /**
     * @param value Name of the pipeline.
     */
    @JvmName("oqkklpnfpxobfmqs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to processors configured for the pipeline.
     */
    @JvmName("aufpdnqedryynbrx")
    public suspend fun processors(`value`: Output<List<String>>) {
        this.processors = value
    }

    @JvmName("drfclwrtekyqlkpv")
    public suspend fun processors(vararg values: Output<String>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Reference to processors configured for the pipeline.
     */
    @JvmName("jcveesgclsffghew")
    public suspend fun processors(values: List<Output<String>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Reference to receivers configured for the pipeline.
     */
    @JvmName("cdtbqddbhnddjoih")
    public suspend fun receivers(`value`: Output<List<String>>) {
        this.receivers = value
    }

    @JvmName("cferqexlldyvpkov")
    public suspend fun receivers(vararg values: Output<String>) {
        this.receivers = Output.all(values.asList())
    }

    /**
     * @param values Reference to receivers configured for the pipeline.
     */
    @JvmName("pdkejiqjgswdqvjf")
    public suspend fun receivers(values: List<Output<String>>) {
        this.receivers = Output.all(values)
    }

    /**
     * @param value The type of pipeline
     */
    @JvmName("lddbgsvhhdfwpenh")
    public suspend fun type(`value`: Output<Either<String, PipelineType>>) {
        this.type = value
    }

    /**
     * @param value Reference to exporters configured for the pipeline.
     */
    @JvmName("xgdgewdttlhjnaae")
    public suspend fun exporters(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exporters = mapped
    }

    /**
     * @param values Reference to exporters configured for the pipeline.
     */
    @JvmName("lctskguxaibhphdq")
    public suspend fun exporters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exporters = mapped
    }

    /**
     * @param value Name of the pipeline.
     */
    @JvmName("rttagcnwncjrxsys")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to processors configured for the pipeline.
     */
    @JvmName("fdxyxonrgxkcsjud")
    public suspend fun processors(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param values Reference to processors configured for the pipeline.
     */
    @JvmName("ufgxqcvconqofkxl")
    public suspend fun processors(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param value Reference to receivers configured for the pipeline.
     */
    @JvmName("rablpjffmbdlyjsx")
    public suspend fun receivers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receivers = mapped
    }

    /**
     * @param values Reference to receivers configured for the pipeline.
     */
    @JvmName("lcfwluamhrjwaiec")
    public suspend fun receivers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receivers = mapped
    }

    /**
     * @param value The type of pipeline
     */
    @JvmName("nlldioosiwbwjlre")
    public suspend fun type(`value`: Either<String, PipelineType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of pipeline
     */
    @JvmName("ueyvugtuwijyjfhe")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PipelineType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of pipeline
     */
    @JvmName("vnuvmnohdqdupqlx")
    public fun type(`value`: PipelineType) {
        val toBeMapped = Either.ofRight<String, PipelineType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        exporters = exporters ?: throw PulumiNullFieldException("exporters"),
        name = name ?: throw PulumiNullFieldException("name"),
        processors = processors,
        receivers = receivers ?: throw PulumiNullFieldException("receivers"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
