@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ProcessorArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.ProcessorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Processor Info.
 * @property batch Batch processor configurations.
 * @property name The name of processor.
 * @property type The type of processor.
 */
public data class ProcessorArgs(
    public val batch: Output<BatchProcessorArgs>? = null,
    public val name: Output<String>,
    public val type: Output<Either<String, ProcessorType>>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ProcessorArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ProcessorArgs =
        com.pulumi.azurenative.monitor.inputs.ProcessorArgs.builder()
            .batch(batch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ProcessorArgs].
 */
@PulumiTagMarker
public class ProcessorArgsBuilder internal constructor() {
    private var batch: Output<BatchProcessorArgs>? = null

    private var name: Output<String>? = null

    private var type: Output<Either<String, ProcessorType>>? = null

    /**
     * @param value Batch processor configurations.
     */
    @JvmName("pydihqaidyjstpfx")
    public suspend fun batch(`value`: Output<BatchProcessorArgs>) {
        this.batch = value
    }

    /**
     * @param value The name of processor.
     */
    @JvmName("xtkmfntovujflbfg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of processor.
     */
    @JvmName("xerlbuiqkpfldsar")
    public suspend fun type(`value`: Output<Either<String, ProcessorType>>) {
        this.type = value
    }

    /**
     * @param value Batch processor configurations.
     */
    @JvmName("xcsjrrhchdcauhoq")
    public suspend fun batch(`value`: BatchProcessorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batch = mapped
    }

    /**
     * @param argument Batch processor configurations.
     */
    @JvmName("fmvwbjkyllyalwhn")
    public suspend fun batch(argument: suspend BatchProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = BatchProcessorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.batch = mapped
    }

    /**
     * @param value The name of processor.
     */
    @JvmName("ytryaegeikpnvgac")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of processor.
     */
    @JvmName("ubmghvbouxwyetxn")
    public suspend fun type(`value`: Either<String, ProcessorType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of processor.
     */
    @JvmName("pgxmphyrnhdvgheo")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProcessorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of processor.
     */
    @JvmName("cxiocqwunsltotfi")
    public fun type(`value`: ProcessorType) {
        val toBeMapped = Either.ofRight<String, ProcessorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProcessorArgs = ProcessorArgs(
        batch = batch,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
