@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ReceiverArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.ReceiverType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Receiver Info.
 * @property name The name of receiver.
 * @property otlp OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers.
 * @property syslog Syslog configurations. This field is mandatory for syslog type receivers.
 * @property type The type of receiver.
 * @property udp UDP receiver configurations. This field is mandatory for UDP receivers.
 */
public data class ReceiverArgs(
    public val name: Output<String>,
    public val otlp: Output<OtlpReceiverArgs>? = null,
    public val syslog: Output<SyslogReceiverArgs>? = null,
    public val type: Output<Either<String, ReceiverType>>,
    public val udp: Output<UdpReceiverArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ReceiverArgs =
        com.pulumi.azurenative.monitor.inputs.ReceiverArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .otlp(otlp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syslog(syslog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .udp(udp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReceiverArgs].
 */
@PulumiTagMarker
public class ReceiverArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var otlp: Output<OtlpReceiverArgs>? = null

    private var syslog: Output<SyslogReceiverArgs>? = null

    private var type: Output<Either<String, ReceiverType>>? = null

    private var udp: Output<UdpReceiverArgs>? = null

    /**
     * @param value The name of receiver.
     */
    @JvmName("mveqikostjloiulg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers.
     */
    @JvmName("fygndkmcnasrxktu")
    public suspend fun otlp(`value`: Output<OtlpReceiverArgs>) {
        this.otlp = value
    }

    /**
     * @param value Syslog configurations. This field is mandatory for syslog type receivers.
     */
    @JvmName("owkpovwvyuwimpwb")
    public suspend fun syslog(`value`: Output<SyslogReceiverArgs>) {
        this.syslog = value
    }

    /**
     * @param value The type of receiver.
     */
    @JvmName("nfgliutfuoujfxii")
    public suspend fun type(`value`: Output<Either<String, ReceiverType>>) {
        this.type = value
    }

    /**
     * @param value UDP receiver configurations. This field is mandatory for UDP receivers.
     */
    @JvmName("gstwfahgihbvpxfn")
    public suspend fun udp(`value`: Output<UdpReceiverArgs>) {
        this.udp = value
    }

    /**
     * @param value The name of receiver.
     */
    @JvmName("bcsxnhfebgeobkmi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers.
     */
    @JvmName("dykixshakohjyvnf")
    public suspend fun otlp(`value`: OtlpReceiverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.otlp = mapped
    }

    /**
     * @param argument OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers.
     */
    @JvmName("vtubqprcbbcvojjr")
    public suspend fun otlp(argument: suspend OtlpReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = OtlpReceiverArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.otlp = mapped
    }

    /**
     * @param value Syslog configurations. This field is mandatory for syslog type receivers.
     */
    @JvmName("dojhdvrvrvtxwwdi")
    public suspend fun syslog(`value`: SyslogReceiverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syslog = mapped
    }

    /**
     * @param argument Syslog configurations. This field is mandatory for syslog type receivers.
     */
    @JvmName("klpthepghxdlrluu")
    public suspend fun syslog(argument: suspend SyslogReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = SyslogReceiverArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.syslog = mapped
    }

    /**
     * @param value The type of receiver.
     */
    @JvmName("gutqnduwfeseqofu")
    public suspend fun type(`value`: Either<String, ReceiverType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of receiver.
     */
    @JvmName("ppdbvmdlfyoxuqhp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReceiverType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of receiver.
     */
    @JvmName("irmnjryvrhcbsssh")
    public fun type(`value`: ReceiverType) {
        val toBeMapped = Either.ofRight<String, ReceiverType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value UDP receiver configurations. This field is mandatory for UDP receivers.
     */
    @JvmName("akrjphvdlitircji")
    public suspend fun udp(`value`: UdpReceiverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udp = mapped
    }

    /**
     * @param argument UDP receiver configurations. This field is mandatory for UDP receivers.
     */
    @JvmName("jgcbpmphgjvtcocb")
    public suspend fun udp(argument: suspend UdpReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = UdpReceiverArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.udp = mapped
    }

    internal fun build(): ReceiverArgs = ReceiverArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        otlp = otlp,
        syslog = syslog,
        type = type ?: throw PulumiNullFieldException("type"),
        udp = udp,
    )
}
