@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.RecordMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Record map for schema in azure monitor.
 * @property from Record Map Key.
 * @property to Record Map Value.
 */
public data class RecordMapArgs(
    public val from: Output<String>,
    public val to: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.RecordMapArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.RecordMapArgs =
        com.pulumi.azurenative.monitor.inputs.RecordMapArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordMapArgs].
 */
@PulumiTagMarker
public class RecordMapArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value Record Map Key.
     */
    @JvmName("nvachksbruknjmii")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value Record Map Value.
     */
    @JvmName("yuyqyiwplhxatlvw")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value Record Map Key.
     */
    @JvmName("fwcgvtnprxheondo")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value Record Map Value.
     */
    @JvmName("druayxiyxtikysew")
    public suspend fun to(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): RecordMapArgs = RecordMapArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
