@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ResourceMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource map for schema in azure monitor.
 * @property from Resource Map Key.
 * @property to Resource Map Value.
 */
public data class ResourceMapArgs(
    public val from: Output<String>,
    public val to: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ResourceMapArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ResourceMapArgs =
        com.pulumi.azurenative.monitor.inputs.ResourceMapArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceMapArgs].
 */
@PulumiTagMarker
public class ResourceMapArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value Resource Map Key.
     */
    @JvmName("ayquhpxgaybkwbhu")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value Resource Map Value.
     */
    @JvmName("kryxucqgxvrfckhu")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value Resource Map Key.
     */
    @JvmName("ymsmaiekavhnbpko")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value Resource Map Value.
     */
    @JvmName("nxrcmppwrxcnjhhr")
    public suspend fun to(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): ResourceMapArgs = ResourceMapArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
