@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.SchemaMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schema map for azure monitor for logs.
 * @property recordMap Record Map.
 * @property resourceMap Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
 * @property scopeMap A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
 */
public data class SchemaMapArgs(
    public val recordMap: Output<List<RecordMapArgs>>,
    public val resourceMap: Output<List<ResourceMapArgs>>? = null,
    public val scopeMap: Output<List<ScopeMapArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.SchemaMapArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.SchemaMapArgs =
        com.pulumi.azurenative.monitor.inputs.SchemaMapArgs.builder()
            .recordMap(
                recordMap.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceMap(
                resourceMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scopeMap(
                scopeMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SchemaMapArgs].
 */
@PulumiTagMarker
public class SchemaMapArgsBuilder internal constructor() {
    private var recordMap: Output<List<RecordMapArgs>>? = null

    private var resourceMap: Output<List<ResourceMapArgs>>? = null

    private var scopeMap: Output<List<ScopeMapArgs>>? = null

    /**
     * @param value Record Map.
     */
    @JvmName("aksnyskxodihomgl")
    public suspend fun recordMap(`value`: Output<List<RecordMapArgs>>) {
        this.recordMap = value
    }

    @JvmName("ehhxjqghlrigyyyd")
    public suspend fun recordMap(vararg values: Output<RecordMapArgs>) {
        this.recordMap = Output.all(values.asList())
    }

    /**
     * @param values Record Map.
     */
    @JvmName("brbfyburobgediee")
    public suspend fun recordMap(values: List<Output<RecordMapArgs>>) {
        this.recordMap = Output.all(values)
    }

    /**
     * @param value Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("gjkwrgjvbcqaslwo")
    public suspend fun resourceMap(`value`: Output<List<ResourceMapArgs>>) {
        this.resourceMap = value
    }

    @JvmName("iyruenbxvbffmrlg")
    public suspend fun resourceMap(vararg values: Output<ResourceMapArgs>) {
        this.resourceMap = Output.all(values.asList())
    }

    /**
     * @param values Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("xhawufmvywtlakoc")
    public suspend fun resourceMap(values: List<Output<ResourceMapArgs>>) {
        this.resourceMap = Output.all(values)
    }

    /**
     * @param value A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("pvjcogqhkndroyop")
    public suspend fun scopeMap(`value`: Output<List<ScopeMapArgs>>) {
        this.scopeMap = value
    }

    @JvmName("gsprmuvehwmtxsrb")
    public suspend fun scopeMap(vararg values: Output<ScopeMapArgs>) {
        this.scopeMap = Output.all(values.asList())
    }

    /**
     * @param values A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("vtljcryfeutyypuc")
    public suspend fun scopeMap(values: List<Output<ScopeMapArgs>>) {
        this.scopeMap = Output.all(values)
    }

    /**
     * @param value Record Map.
     */
    @JvmName("fvfhpbropgrcqyyf")
    public suspend fun recordMap(`value`: List<RecordMapArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordMap = mapped
    }

    /**
     * @param argument Record Map.
     */
    @JvmName("vvukmnrhflgwgbsf")
    public suspend fun recordMap(argument: List<suspend RecordMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RecordMapArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.recordMap = mapped
    }

    /**
     * @param argument Record Map.
     */
    @JvmName("nqsthvwhbshddtfx")
    public suspend fun recordMap(vararg argument: suspend RecordMapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RecordMapArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.recordMap = mapped
    }

    /**
     * @param argument Record Map.
     */
    @JvmName("qdlgfekrjxgdehrg")
    public suspend fun recordMap(argument: suspend RecordMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecordMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.recordMap = mapped
    }

    /**
     * @param values Record Map.
     */
    @JvmName("oyaxpunmbyirypek")
    public suspend fun recordMap(vararg values: RecordMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordMap = mapped
    }

    /**
     * @param value Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("odkknehrhnsprpao")
    public suspend fun resourceMap(`value`: List<ResourceMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceMap = mapped
    }

    /**
     * @param argument Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("uhrovqclccmjfgey")
    public suspend fun resourceMap(argument: List<suspend ResourceMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceMapArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.resourceMap = mapped
    }

    /**
     * @param argument Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("dojggiqnmcsgtwon")
    public suspend fun resourceMap(vararg argument: suspend ResourceMapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceMapArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.resourceMap = mapped
    }

    /**
     * @param argument Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("qwlkerbevrkmdohi")
    public suspend fun resourceMap(argument: suspend ResourceMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceMap = mapped
    }

    /**
     * @param values Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
     */
    @JvmName("sckjqdrxykgfmfbh")
    public suspend fun resourceMap(vararg values: ResourceMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceMap = mapped
    }

    /**
     * @param value A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("bdsnbsrlqmivpbem")
    public suspend fun scopeMap(`value`: List<ScopeMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeMap = mapped
    }

    /**
     * @param argument A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("cgfbouppcwelnecx")
    public suspend fun scopeMap(argument: List<suspend ScopeMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ScopeMapArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.scopeMap = mapped
    }

    /**
     * @param argument A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("krnoxsrxkenyiefh")
    public suspend fun scopeMap(vararg argument: suspend ScopeMapArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ScopeMapArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.scopeMap = mapped
    }

    /**
     * @param argument A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("nllqbvoknrrrxdjm")
    public suspend fun scopeMap(argument: suspend ScopeMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScopeMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scopeMap = mapped
    }

    /**
     * @param values A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
     */
    @JvmName("btotpqrkuhydfbhu")
    public suspend fun scopeMap(vararg values: ScopeMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopeMap = mapped
    }

    internal fun build(): SchemaMapArgs = SchemaMapArgs(
        recordMap = recordMap ?: throw PulumiNullFieldException("recordMap"),
        resourceMap = resourceMap,
        scopeMap = scopeMap,
    )
}
