@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ScopeMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Scope map for schema in azure monitor.
 * @property from Scope Map Key.
 * @property to Scope Map Value.
 */
public data class ScopeMapArgs(
    public val from: Output<String>,
    public val to: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ScopeMapArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ScopeMapArgs =
        com.pulumi.azurenative.monitor.inputs.ScopeMapArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeMapArgs].
 */
@PulumiTagMarker
public class ScopeMapArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value Scope Map Key.
     */
    @JvmName("iijnthnvokxdgqfh")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value Scope Map Value.
     */
    @JvmName("tlmehmfxcenvbsos")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value Scope Map Key.
     */
    @JvmName("nvehxenhlyeumikv")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value Scope Map Value.
     */
    @JvmName("dnkkiudyxtwvxldm")
    public suspend fun to(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): ScopeMapArgs = ScopeMapArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
