@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.ServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Service Info.
 * @property persistence Persistence options to all pipelines in the instance.
 * @property pipelines Pipelines belonging to a given pipeline group.
 */
public data class ServiceArgs(
    public val persistence: Output<PersistenceConfigurationsArgs>? = null,
    public val pipelines: Output<List<PipelineArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.ServiceArgs =
        com.pulumi.azurenative.monitor.inputs.ServiceArgs.builder()
            .persistence(persistence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pipelines(
                pipelines.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var persistence: Output<PersistenceConfigurationsArgs>? = null

    private var pipelines: Output<List<PipelineArgs>>? = null

    /**
     * @param value Persistence options to all pipelines in the instance.
     */
    @JvmName("ayvcmuxnlkyruyta")
    public suspend fun persistence(`value`: Output<PersistenceConfigurationsArgs>) {
        this.persistence = value
    }

    /**
     * @param value Pipelines belonging to a given pipeline group.
     */
    @JvmName("wxxafjjcrdghfdod")
    public suspend fun pipelines(`value`: Output<List<PipelineArgs>>) {
        this.pipelines = value
    }

    @JvmName("wonvgbuamuocpyei")
    public suspend fun pipelines(vararg values: Output<PipelineArgs>) {
        this.pipelines = Output.all(values.asList())
    }

    /**
     * @param values Pipelines belonging to a given pipeline group.
     */
    @JvmName("wgyfoegbkyielefp")
    public suspend fun pipelines(values: List<Output<PipelineArgs>>) {
        this.pipelines = Output.all(values)
    }

    /**
     * @param value Persistence options to all pipelines in the instance.
     */
    @JvmName("iladhdcgjqqmeidu")
    public suspend fun persistence(`value`: PersistenceConfigurationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistence = mapped
    }

    /**
     * @param argument Persistence options to all pipelines in the instance.
     */
    @JvmName("gdbhuedfwefprtri")
    public suspend fun persistence(argument: suspend PersistenceConfigurationsArgsBuilder.() -> Unit) {
        val toBeMapped = PersistenceConfigurationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.persistence = mapped
    }

    /**
     * @param value Pipelines belonging to a given pipeline group.
     */
    @JvmName("poddavacifynbgbm")
    public suspend fun pipelines(`value`: List<PipelineArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines belonging to a given pipeline group.
     */
    @JvmName("wnidacvvfgkvbpsk")
    public suspend fun pipelines(argument: List<suspend PipelineArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PipelineArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines belonging to a given pipeline group.
     */
    @JvmName("iffwkndumrwqrmop")
    public suspend fun pipelines(vararg argument: suspend PipelineArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PipelineArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param argument Pipelines belonging to a given pipeline group.
     */
    @JvmName("lxpqxsornoxqbrjm")
    public suspend fun pipelines(argument: suspend PipelineArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PipelineArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pipelines = mapped
    }

    /**
     * @param values Pipelines belonging to a given pipeline group.
     */
    @JvmName("rqnhjnvqdwjyrdlw")
    public suspend fun pipelines(vararg values: PipelineArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelines = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        persistence = persistence,
        pipelines = pipelines ?: throw PulumiNullFieldException("pipelines"),
    )
}
