@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.SyslogReceiverArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.SyslogProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Base receiver using TCP as transport protocol.
 * @property endpoint Syslog receiver endpoint definition. Example: 0.0.0.0:<port>.
 * @property protocol Protocol to parse syslog messages. Default rfc3164
 */
public data class SyslogReceiverArgs(
    public val endpoint: Output<String>,
    public val protocol: Output<Either<String, SyslogProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.SyslogReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.SyslogReceiverArgs =
        com.pulumi.azurenative.monitor.inputs.SyslogReceiverArgs.builder()
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SyslogReceiverArgs].
 */
@PulumiTagMarker
public class SyslogReceiverArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var protocol: Output<Either<String, SyslogProtocol>>? = null

    /**
     * @param value Syslog receiver endpoint definition. Example: 0.0.0.0:<port>.
     */
    @JvmName("vhmsfvpcmndsacka")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Protocol to parse syslog messages. Default rfc3164
     */
    @JvmName("ouskgfecgiqoiwck")
    public suspend fun protocol(`value`: Output<Either<String, SyslogProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Syslog receiver endpoint definition. Example: 0.0.0.0:<port>.
     */
    @JvmName("tqxjfsekdfxinyuy")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Protocol to parse syslog messages. Default rfc3164
     */
    @JvmName("pyonehbeljbpvppo")
    public suspend fun protocol(`value`: Either<String, SyslogProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol to parse syslog messages. Default rfc3164
     */
    @JvmName("ifqkqtipiipjrvex")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyslogProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol to parse syslog messages. Default rfc3164
     */
    @JvmName("oqkidjqlbguhjnoi")
    public fun protocol(`value`: SyslogProtocol) {
        val toBeMapped = Either.ofRight<String, SyslogProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): SyslogReceiverArgs = SyslogReceiverArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        protocol = protocol,
    )
}
