@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.TcpExporterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Base exporter using TCP as transport protocol.
 * @property url TCP url to export.
 */
public data class TcpExporterArgs(
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.TcpExporterArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.TcpExporterArgs =
        com.pulumi.azurenative.monitor.inputs.TcpExporterArgs.builder()
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TcpExporterArgs].
 */
@PulumiTagMarker
public class TcpExporterArgsBuilder internal constructor() {
    private var url: Output<String>? = null

    /**
     * @param value TCP url to export.
     */
    @JvmName("oapqdpukedgtxydu")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value TCP url to export.
     */
    @JvmName("iorrmoearsahdecl")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): TcpExporterArgs = TcpExporterArgs(
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
