@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.UdpReceiverArgs.builder
import com.pulumi.azurenative.monitor.kotlin.enums.StreamEncodingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Receiver using UDP as transport protocol.
 * @property encoding The encoding of the stream being received.
 * @property endpoint TCP endpoint definition. Example: 0.0.0.0:<port>.
 * @property readQueueLength Max read queue length.
 */
public data class UdpReceiverArgs(
    public val encoding: Output<Either<String, StreamEncodingType>>? = null,
    public val endpoint: Output<String>,
    public val readQueueLength: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.UdpReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.UdpReceiverArgs =
        com.pulumi.azurenative.monitor.inputs.UdpReceiverArgs.builder()
            .encoding(
                encoding?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .readQueueLength(readQueueLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UdpReceiverArgs].
 */
@PulumiTagMarker
public class UdpReceiverArgsBuilder internal constructor() {
    private var encoding: Output<Either<String, StreamEncodingType>>? = null

    private var endpoint: Output<String>? = null

    private var readQueueLength: Output<Int>? = null

    /**
     * @param value The encoding of the stream being received.
     */
    @JvmName("icefklrirqjpffwj")
    public suspend fun encoding(`value`: Output<Either<String, StreamEncodingType>>) {
        this.encoding = value
    }

    /**
     * @param value TCP endpoint definition. Example: 0.0.0.0:<port>.
     */
    @JvmName("tpfdkpcsuylctoqy")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Max read queue length.
     */
    @JvmName("frqbsuuxeljvjbiq")
    public suspend fun readQueueLength(`value`: Output<Int>) {
        this.readQueueLength = value
    }

    /**
     * @param value The encoding of the stream being received.
     */
    @JvmName("oibdtmxmaolbmbur")
    public suspend fun encoding(`value`: Either<String, StreamEncodingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The encoding of the stream being received.
     */
    @JvmName("faelxdfjfgflmaru")
    public fun encoding(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StreamEncodingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value The encoding of the stream being received.
     */
    @JvmName("ivllmsaycurpmscw")
    public fun encoding(`value`: StreamEncodingType) {
        val toBeMapped = Either.ofRight<String, StreamEncodingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value TCP endpoint definition. Example: 0.0.0.0:<port>.
     */
    @JvmName("tsftkdsqgvyisbem")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Max read queue length.
     */
    @JvmName("dohyxtjtjdnjmfvi")
    public suspend fun readQueueLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readQueueLength = mapped
    }

    internal fun build(): UdpReceiverArgs = UdpReceiverArgs(
        encoding = encoding,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        readQueueLength = readQueueLength,
    )
}
