@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Monitor Workspace Logs Api configurations.
 * @property dataCollectionEndpointUrl Data collection endpoint ingestion url.
 * @property dataCollectionRule Data Collection Rule (DCR) immutable id.
 * @property schema The schema mapping for incoming data.
 * @property stream Stream name in destination. Azure Monitor stream is related to the destination table.
 */
public data class AzureMonitorWorkspaceLogsApiConfigResponse(
    public val dataCollectionEndpointUrl: String,
    public val dataCollectionRule: String,
    public val schema: SchemaMapResponse,
    public val stream: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.AzureMonitorWorkspaceLogsApiConfigResponse): AzureMonitorWorkspaceLogsApiConfigResponse = AzureMonitorWorkspaceLogsApiConfigResponse(
            dataCollectionEndpointUrl = javaType.dataCollectionEndpointUrl(),
            dataCollectionRule = javaType.dataCollectionRule(),
            schema = javaType.schema().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.SchemaMapResponse.Companion.toKotlin(args0)
            }),
            stream = javaType.stream(),
        )
    }
}
