@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Suppress

/**
 * Azure Monitor Workspace Logs specific configurations.
 * @property api API configurations for Azure Monitor workspace exporter.
 * @property cache Cache configurations.
 * @property concurrency Concurrency configuration for the exporter.
 */
public data class AzureMonitorWorkspaceLogsExporterResponse(
    public val api: AzureMonitorWorkspaceLogsApiConfigResponse,
    public val cache: CacheConfigurationResponse? = null,
    public val concurrency: ConcurrencyConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.AzureMonitorWorkspaceLogsExporterResponse): AzureMonitorWorkspaceLogsExporterResponse = AzureMonitorWorkspaceLogsExporterResponse(
            api = javaType.api().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceLogsApiConfigResponse.Companion.toKotlin(args0)
            }),
            cache = javaType.cache().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.CacheConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            concurrency = javaType.concurrency().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ConcurrencyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
