@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Data Collection Rule and Endpoint used for ingestion by default.
 * @property dataCollectionEndpointResourceId The Azure resource Id of the default data collection endpoint for this Azure Monitor Workspace.
 * @property dataCollectionRuleResourceId The Azure resource Id of the default data collection rule for this Azure Monitor Workspace.
 */
public data class AzureMonitorWorkspaceResponseDefaultIngestionSettings(
    public val dataCollectionEndpointResourceId: String,
    public val dataCollectionRuleResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.AzureMonitorWorkspaceResponseDefaultIngestionSettings): AzureMonitorWorkspaceResponseDefaultIngestionSettings =
            AzureMonitorWorkspaceResponseDefaultIngestionSettings(
                dataCollectionEndpointResourceId = javaType.dataCollectionEndpointResourceId(),
                dataCollectionRuleResourceId = javaType.dataCollectionRuleResourceId(),
            )
    }
}
