@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties related to the metrics container in the Azure Monitor Workspace
 * @property internalId An internal identifier for the metrics container. Only to be used by the system
 * @property prometheusQueryEndpoint The Prometheus query endpoint for the Azure Monitor Workspace
 */
public data class AzureMonitorWorkspaceResponseMetrics(
    public val internalId: String,
    public val prometheusQueryEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.AzureMonitorWorkspaceResponseMetrics): AzureMonitorWorkspaceResponseMetrics = AzureMonitorWorkspaceResponseMetrics(
            internalId = javaType.internalId(),
            prometheusQueryEndpoint = javaType.prometheusQueryEndpoint(),
        )
    }
}
