@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Batch processor.
 * @property batchSize Size of the batch.
 * @property timeout Timeout in milliseconds.
 */
public data class BatchProcessorResponse(
    public val batchSize: Int? = null,
    public val timeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.BatchProcessorResponse): BatchProcessorResponse = BatchProcessorResponse(
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
