@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Cache configurations.
 * @property maxStorageUsage Max storage usage in megabytes.
 * @property retentionPeriod Retention period in minutes.
 */
public data class CacheConfigurationResponse(
    public val maxStorageUsage: Int? = null,
    public val retentionPeriod: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.CacheConfigurationResponse): CacheConfigurationResponse = CacheConfigurationResponse(
            maxStorageUsage = javaType.maxStorageUsage().map({ args0 -> args0 }).orElse(null),
            retentionPeriod = javaType.retentionPeriod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
