@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Concurrent publishing configuration.
 * @property batchQueueSize Size of the queue for log batches.
 * @property workerCount Number of parallel workers processing the log queues.
 */
public data class ConcurrencyConfigurationResponse(
    public val batchQueueSize: Int? = null,
    public val workerCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ConcurrencyConfigurationResponse): ConcurrencyConfigurationResponse = ConcurrencyConfigurationResponse(
            batchQueueSize = javaType.batchQueueSize().map({ args0 -> args0 }).orElse(null),
            workerCount = javaType.workerCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
