@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Exporter Info.
 * @property azureMonitorWorkspaceLogs Azure Monitor Workspace Logs specific configurations.
 * @property name The name of exporter.
 * @property tcp TCP based exporter. Used for pipelineGroup exporter.
 * @property type The type of exporter.
 */
public data class ExporterResponse(
    public val azureMonitorWorkspaceLogs: AzureMonitorWorkspaceLogsExporterResponse? = null,
    public val name: String,
    public val tcp: TcpExporterResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ExporterResponse): ExporterResponse = ExporterResponse(
            azureMonitorWorkspaceLogs = javaType.azureMonitorWorkspaceLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceLogsExporterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            tcp = javaType.tcp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.TcpExporterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
