@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The extended location info.
 * @property name The name of extended location.
 * @property type The type of extended location.
 */
public data class ExtendedLocationResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ExtendedLocationResponse): ExtendedLocationResponse = ExtendedLocationResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
