@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Azure Monitor Workspace definition
 * @property accountId The immutable Id of the Azure Monitor Workspace. This property is read-only.
 * @property defaultIngestionSettings The Data Collection Rule and Endpoint used for ingestion by default.
 * @property etag Resource entity tag (ETag)
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property metrics Properties related to the metrics container in the Azure Monitor Workspace
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connections
 * @property provisioningState The provisioning state of the Azure Monitor Workspace. Set to Succeeded if everything is healthy.
 * @property publicNetworkAccess Gets or sets allow or disallow public network access to Azure Monitor Workspace
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAzureMonitorWorkspaceResult(
    public val accountId: String,
    public val defaultIngestionSettings: AzureMonitorWorkspaceResponseDefaultIngestionSettings,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val metrics: AzureMonitorWorkspaceResponseMetrics,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.GetAzureMonitorWorkspaceResult): GetAzureMonitorWorkspaceResult = GetAzureMonitorWorkspaceResult(
            accountId = javaType.accountId(),
            defaultIngestionSettings = javaType.defaultIngestionSettings().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceResponseDefaultIngestionSettings.Companion.toKotlin(args0)
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            metrics = javaType.metrics().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceResponseMetrics.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
