@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A pipeline group definition.
 * @property exporters The exporters specified for a pipeline group instance.
 * @property extendedLocation The extended location for given pipeline group.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkingConfigurations Networking configurations for the pipeline group instance.
 * @property processors The processors specified for a pipeline group instance.
 * @property provisioningState The provisioning state of a pipeline group instance. Set to Succeeded if everything is healthy.
 * @property receivers The receivers specified for a pipeline group instance.
 * @property replicas Defines the amount of replicas of the pipeline group instance.
 * @property service The service section for a given pipeline group instance.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPipelineGroupResult(
    public val exporters: List<ExporterResponse>,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkingConfigurations: List<NetworkingConfigurationResponse>? = null,
    public val processors: List<ProcessorResponse>,
    public val provisioningState: String,
    public val receivers: List<ReceiverResponse>,
    public val replicas: Int? = null,
    public val service: ServiceResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.GetPipelineGroupResult): GetPipelineGroupResult = GetPipelineGroupResult(
            exporters = javaType.exporters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ExporterResponse.Companion.toKotlin(args0)
                })
            }),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkingConfigurations = javaType.networkingConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.NetworkingConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            processors = javaType.processors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ProcessorResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            receivers = javaType.receivers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ReceiverResponse.Companion.toKotlin(args0)
                })
            }),
            replicas = javaType.replicas().map({ args0 -> args0 }).orElse(null),
            service = javaType.service().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.ServiceResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.monitor.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
