@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Networking configuration for the pipeline group instance.
 * @property externalNetworkingMode External networking mode.
 * @property host The address exposed on the cluster. Example: azuremonitorpipeline.contoso.com.
 * @property routes Networking routes configuration.
 */
public data class NetworkingConfigurationResponse(
    public val externalNetworkingMode: String,
    public val host: String? = null,
    public val routes: List<NetworkingRouteResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.NetworkingConfigurationResponse): NetworkingConfigurationResponse = NetworkingConfigurationResponse(
            externalNetworkingMode = javaType.externalNetworkingMode(),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.NetworkingRouteResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
