@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Networking route configuration.
 * @property path Route path.
 * @property port The port that will be configured externally. If not specified, it will use the port from the receiver definition.
 * @property receiver The name of the previously defined receiver.
 * @property subdomain Route subdomain.
 */
public data class NetworkingRouteResponse(
    public val path: String? = null,
    public val port: Int? = null,
    public val `receiver`: String,
    public val subdomain: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.NetworkingRouteResponse): NetworkingRouteResponse = NetworkingRouteResponse(
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            `receiver` = javaType.`receiver`(),
            subdomain = javaType.subdomain().map({ args0 -> args0 }).orElse(null),
        )
    }
}
