@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Persistence options to all pipelines in the instance.
 * @property persistentVolumeName The name of the mounted persistent volume.
 */
public data class PersistenceConfigurationsResponse(
    public val persistentVolumeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.PersistenceConfigurationsResponse): PersistenceConfigurationsResponse = PersistenceConfigurationsResponse(
            persistentVolumeName = javaType.persistentVolumeName(),
        )
    }
}
