@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Pipeline Info.
 * @property exporters Reference to exporters configured for the pipeline.
 * @property name Name of the pipeline.
 * @property processors Reference to processors configured for the pipeline.
 * @property receivers Reference to receivers configured for the pipeline.
 * @property type The type of pipeline
 */
public data class PipelineResponse(
    public val exporters: List<String>,
    public val name: String,
    public val processors: List<String>? = null,
    public val receivers: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.PipelineResponse): PipelineResponse = PipelineResponse(
            exporters = javaType.exporters().map({ args0 -> args0 }),
            name = javaType.name(),
            processors = javaType.processors().map({ args0 -> args0 }),
            receivers = javaType.receivers().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
