@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Processor Info.
 * @property batch Batch processor configurations.
 * @property name The name of processor.
 * @property type The type of processor.
 */
public data class ProcessorResponse(
    public val batch: BatchProcessorResponse? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ProcessorResponse): ProcessorResponse = ProcessorResponse(
            batch = javaType.batch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.BatchProcessorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
