@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Receiver Info.
 * @property name The name of receiver.
 * @property otlp OTLP receiver configurations. This field is mandatory for OTLP and pipelineGroup receivers.
 * @property syslog Syslog configurations. This field is mandatory for syslog type receivers.
 * @property type The type of receiver.
 * @property udp UDP receiver configurations. This field is mandatory for UDP receivers.
 */
public data class ReceiverResponse(
    public val name: String,
    public val otlp: OtlpReceiverResponse? = null,
    public val syslog: SyslogReceiverResponse? = null,
    public val type: String,
    public val udp: UdpReceiverResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ReceiverResponse): ReceiverResponse = ReceiverResponse(
            name = javaType.name(),
            otlp = javaType.otlp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.OtlpReceiverResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            syslog = javaType.syslog().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.SyslogReceiverResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            udp = javaType.udp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.UdpReceiverResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
