@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Record map for schema in azure monitor.
 * @property from Record Map Key.
 * @property to Record Map Value.
 */
public data class RecordMapResponse(
    public val from: String,
    public val to: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.RecordMapResponse): RecordMapResponse = RecordMapResponse(
            from = javaType.from(),
            to = javaType.to(),
        )
    }
}
