@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource map for schema in azure monitor.
 * @property from Resource Map Key.
 * @property to Resource Map Value.
 */
public data class ResourceMapResponse(
    public val from: String,
    public val to: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ResourceMapResponse): ResourceMapResponse = ResourceMapResponse(
            from = javaType.from(),
            to = javaType.to(),
        )
    }
}
