@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Schema map for azure monitor for logs.
 * @property recordMap Record Map.
 * @property resourceMap Resource Map captures information about the entity for which telemetry is recorded. For example, metrics exposed by a Kubernetes container can be linked to a resource that specifies the cluster, namespace, pod, and container name.Resource may capture an entire hierarchy of entity identification. It may describe the host in the cloud and specific container or an application running in the process.
 * @property scopeMap A scope map is a logical unit of the application code with which the emitted telemetry can be associated.
 */
public data class SchemaMapResponse(
    public val recordMap: List<RecordMapResponse>,
    public val resourceMap: List<ResourceMapResponse>? = null,
    public val scopeMap: List<ScopeMapResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.SchemaMapResponse): SchemaMapResponse = SchemaMapResponse(
            recordMap = javaType.recordMap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.RecordMapResponse.Companion.toKotlin(args0)
                })
            }),
            resourceMap = javaType.resourceMap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ResourceMapResponse.Companion.toKotlin(args0)
                })
            }),
            scopeMap = javaType.scopeMap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.ScopeMapResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
