@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Scope map for schema in azure monitor.
 * @property from Scope Map Key.
 * @property to Scope Map Value.
 */
public data class ScopeMapResponse(
    public val from: String,
    public val to: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ScopeMapResponse): ScopeMapResponse = ScopeMapResponse(
            from = javaType.from(),
            to = javaType.to(),
        )
    }
}
