@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Service Info.
 * @property persistence Persistence options to all pipelines in the instance.
 * @property pipelines Pipelines belonging to a given pipeline group.
 */
public data class ServiceResponse(
    public val persistence: PersistenceConfigurationsResponse? = null,
    public val pipelines: List<PipelineResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.ServiceResponse): ServiceResponse = ServiceResponse(
            persistence = javaType.persistence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.PersistenceConfigurationsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.monitor.kotlin.outputs.PipelineResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
