@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Base receiver using TCP as transport protocol.
 * @property endpoint Syslog receiver endpoint definition. Example: 0.0.0.0:<port>.
 * @property protocol Protocol to parse syslog messages. Default rfc3164
 */
public data class SyslogReceiverResponse(
    public val endpoint: String,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.SyslogReceiverResponse): SyslogReceiverResponse = SyslogReceiverResponse(
            endpoint = javaType.endpoint(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
