@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Base exporter using TCP as transport protocol.
 * @property url TCP url to export.
 */
public data class TcpExporterResponse(
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.TcpExporterResponse): TcpExporterResponse = TcpExporterResponse(
            url = javaType.url(),
        )
    }
}
