@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Receiver using UDP as transport protocol.
 * @property encoding The encoding of the stream being received.
 * @property endpoint TCP endpoint definition. Example: 0.0.0.0:<port>.
 * @property readQueueLength Max read queue length.
 */
public data class UdpReceiverResponse(
    public val encoding: String? = null,
    public val endpoint: String,
    public val readQueueLength: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.outputs.UdpReceiverResponse): UdpReceiverResponse = UdpReceiverResponse(
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            readQueueLength = javaType.readQueueLength().map({ args0 -> args0 }).orElse(null),
        )
    }
}
