@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Pool].
 */
@PulumiTagMarker
public class PoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PoolArgs = PoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PoolArgsBuilder.() -> Unit) {
        val builder = PoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pool {
        val builtJavaResource = com.pulumi.azurenative.netapp.Pool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pool(builtJavaResource)
    }
}

/**
 * Capacity pool resource
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-08-15, 2019-07-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01, 2023-07-01-preview, 2023-11-01.
 * ## Example Usage
 * ### Pools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.NetApp.Pool("pool", new()
 *     {
 *         AccountName = "account1",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         QosType = AzureNative.NetApp.QosType.Auto,
 *         ResourceGroupName = "myRG",
 *         ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *         Size = 4398046511104,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewPool(ctx, "pool", &netapp.PoolArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			QosType:           pulumi.String(netapp.QosTypeAuto),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			ServiceLevel:      pulumi.String(netapp.ServiceLevelPremium),
 * 			Size:              pulumi.Float64(4398046511104),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Pool;
 * import com.pulumi.azurenative.netapp.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .accountName("account1")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .qosType("Auto")
 *             .resourceGroupName("myRG")
 *             .serviceLevel("Premium")
 *             .size(4398046511104)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Pool account1/pool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}
 * ```
 */
public class Pool internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.Pool,
) : KotlinCustomResource(javaResource, PoolMapper) {
    /**
     * If enabled (true) the pool can contain cool Access enabled volumes.
     */
    public val coolAccess: Output<Boolean>?
        get() = javaResource.coolAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
     */
    public val encryptionType: Output<String>?
        get() = javaResource.encryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * UUID v4 used to identify the Pool
     */
    public val poolId: Output<String>
        get() = javaResource.poolId().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The qos type of the pool
     */
    public val qosType: Output<String>?
        get() = javaResource.qosType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The service level of the file system
     */
    public val serviceLevel: Output<String>
        get() = javaResource.serviceLevel().applyValue({ args0 -> args0 })

    /**
     * Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
     */
    public val size: Output<Double>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Total throughput of pool in MiB/s
     */
    public val totalThroughputMibps: Output<Double>
        get() = javaResource.totalThroughputMibps().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Utilized throughput of pool in MiB/s
     */
    public val utilizedThroughputMibps: Output<Double>
        get() = javaResource.utilizedThroughputMibps().applyValue({ args0 -> args0 })
}

public object PoolMapper : ResourceMapper<Pool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.Pool::class == javaResource::class

    override fun map(javaResource: Resource): Pool = Pool(
        javaResource as
            com.pulumi.azurenative.netapp.Pool,
    )
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pool].
 */
public suspend fun pool(name: String, block: suspend PoolResourceBuilder.() -> Unit): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pool(name: String): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
