@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.azurenative.netapp.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Snapshot of a Volume
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-08-15, 2019-06-01, 2019-10-01, 2019-11-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01, 2023-07-01-preview, 2023-11-01.
 * ## Example Usage
 * ### Snapshots_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.NetApp.Snapshot("snapshot", new()
 *     {
 *         AccountName = "account1",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         SnapshotName = "snapshot1",
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewSnapshot(ctx, "snapshot", &netapp.SnapshotArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			SnapshotName:      pulumi.String("snapshot1"),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Snapshot;
 * import com.pulumi.azurenative.netapp.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .accountName("account1")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .snapshotName("snapshot1")
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Snapshot account1/pool1/volume1/snapshot1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/snapshots/{snapshotName}
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * The creation date of the snapshot
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * UUID v4 used to identify the Snapshot
     */
    public val snapshotId: Output<String>
        get() = javaResource.snapshotId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.azurenative.netapp.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
