@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.DailyScheduleResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.HourlyScheduleResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.MonthlyScheduleResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.WeeklyScheduleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.netapp.kotlin.outputs.DailyScheduleResponse.Companion.toKotlin as dailyScheduleResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.HourlyScheduleResponse.Companion.toKotlin as hourlyScheduleResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.MonthlyScheduleResponse.Companion.toKotlin as monthlyScheduleResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.WeeklyScheduleResponse.Companion.toKotlin as weeklyScheduleResponseToKotlin

/**
 * Builder for [SnapshotPolicy].
 */
@PulumiTagMarker
public class SnapshotPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotPolicyArgs = SnapshotPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotPolicyArgsBuilder.() -> Unit) {
        val builder = SnapshotPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotPolicy {
        val builtJavaResource = com.pulumi.azurenative.netapp.SnapshotPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotPolicy(builtJavaResource)
    }
}

/**
 * Snapshot policy information
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01, 2023-07-01-preview, 2023-11-01.
 * ## Example Usage
 * ### SnapshotPolicies_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshotPolicy = new AzureNative.NetApp.SnapshotPolicy("snapshotPolicy", new()
 *     {
 *         AccountName = "account1",
 *         DailySchedule = new AzureNative.NetApp.Inputs.DailyScheduleArgs
 *         {
 *             Hour = 14,
 *             Minute = 30,
 *             SnapshotsToKeep = 4,
 *         },
 *         Enabled = true,
 *         HourlySchedule = new AzureNative.NetApp.Inputs.HourlyScheduleArgs
 *         {
 *             Minute = 50,
 *             SnapshotsToKeep = 2,
 *         },
 *         Location = "eastus",
 *         MonthlySchedule = new AzureNative.NetApp.Inputs.MonthlyScheduleArgs
 *         {
 *             DaysOfMonth = "10,11,12",
 *             Hour = 14,
 *             Minute = 15,
 *             SnapshotsToKeep = 5,
 *         },
 *         ResourceGroupName = "myRG",
 *         SnapshotPolicyName = "snapshotPolicyName",
 *         WeeklySchedule = new AzureNative.NetApp.Inputs.WeeklyScheduleArgs
 *         {
 *             Day = "Wednesday",
 *             Hour = 14,
 *             Minute = 45,
 *             SnapshotsToKeep = 3,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewSnapshotPolicy(ctx, "snapshotPolicy", &netapp.SnapshotPolicyArgs{
 * 			AccountName: pulumi.String("account1"),
 * 			DailySchedule: &netapp.DailyScheduleArgs{
 * 				Hour:            pulumi.Int(14),
 * 				Minute:          pulumi.Int(30),
 * 				SnapshotsToKeep: pulumi.Int(4),
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			HourlySchedule: &netapp.HourlyScheduleArgs{
 * 				Minute:          pulumi.Int(50),
 * 				SnapshotsToKeep: pulumi.Int(2),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			MonthlySchedule: &netapp.MonthlyScheduleArgs{
 * 				DaysOfMonth:     pulumi.String("10,11,12"),
 * 				Hour:            pulumi.Int(14),
 * 				Minute:          pulumi.Int(15),
 * 				SnapshotsToKeep: pulumi.Int(5),
 * 			},
 * 			ResourceGroupName:  pulumi.String("myRG"),
 * 			SnapshotPolicyName: pulumi.String("snapshotPolicyName"),
 * 			WeeklySchedule: &netapp.WeeklyScheduleArgs{
 * 				Day:             pulumi.String("Wednesday"),
 * 				Hour:            pulumi.Int(14),
 * 				Minute:          pulumi.Int(45),
 * 				SnapshotsToKeep: pulumi.Int(3),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.SnapshotPolicy;
 * import com.pulumi.azurenative.netapp.SnapshotPolicyArgs;
 * import com.pulumi.azurenative.netapp.inputs.DailyScheduleArgs;
 * import com.pulumi.azurenative.netapp.inputs.HourlyScheduleArgs;
 * import com.pulumi.azurenative.netapp.inputs.MonthlyScheduleArgs;
 * import com.pulumi.azurenative.netapp.inputs.WeeklyScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshotPolicy = new SnapshotPolicy("snapshotPolicy", SnapshotPolicyArgs.builder()
 *             .accountName("account1")
 *             .dailySchedule(DailyScheduleArgs.builder()
 *                 .hour(14)
 *                 .minute(30)
 *                 .snapshotsToKeep(4)
 *                 .build())
 *             .enabled(true)
 *             .hourlySchedule(HourlyScheduleArgs.builder()
 *                 .minute(50)
 *                 .snapshotsToKeep(2)
 *                 .build())
 *             .location("eastus")
 *             .monthlySchedule(MonthlyScheduleArgs.builder()
 *                 .daysOfMonth("10,11,12")
 *                 .hour(14)
 *                 .minute(15)
 *                 .snapshotsToKeep(5)
 *                 .build())
 *             .resourceGroupName("myRG")
 *             .snapshotPolicyName("snapshotPolicyName")
 *             .weeklySchedule(WeeklyScheduleArgs.builder()
 *                 .day("Wednesday")
 *                 .hour(14)
 *                 .minute(45)
 *                 .snapshotsToKeep(3)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:SnapshotPolicy account1/snapshotPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/snapshotPolicies/{snapshotPolicyName}
 * ```
 */
public class SnapshotPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.SnapshotPolicy,
) : KotlinCustomResource(javaResource, SnapshotPolicyMapper) {
    /**
     * Schedule for daily snapshots
     */
    public val dailySchedule: Output<DailyScheduleResponse>?
        get() = javaResource.dailySchedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dailyScheduleResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The property to decide policy is enabled or not
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Schedule for hourly snapshots
     */
    public val hourlySchedule: Output<HourlyScheduleResponse>?
        get() = javaResource.hourlySchedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hourlyScheduleResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Schedule for monthly snapshots
     */
    public val monthlySchedule: Output<MonthlyScheduleResponse>?
        get() = javaResource.monthlySchedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> monthlyScheduleResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Schedule for weekly snapshots
     */
    public val weeklySchedule: Output<WeeklyScheduleResponse>?
        get() = javaResource.weeklySchedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> weeklyScheduleResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object SnapshotPolicyMapper : ResourceMapper<SnapshotPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.SnapshotPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotPolicy = SnapshotPolicy(
        javaResource as
            com.pulumi.azurenative.netapp.SnapshotPolicy,
    )
}

/**
 * @see [SnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotPolicy].
 */
public suspend fun snapshotPolicy(
    name: String,
    block: suspend SnapshotPolicyResourceBuilder.() -> Unit,
): SnapshotPolicy {
    val builder = SnapshotPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotPolicy(name: String): SnapshotPolicy {
    val builder = SnapshotPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
