@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.VolumeGroupMetaDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumeGroupVolumePropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumeGroupMetaDataResponse.Companion.toKotlin as volumeGroupMetaDataResponseToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.VolumeGroupVolumePropertiesResponse.Companion.toKotlin as volumeGroupVolumePropertiesResponseToKotlin

/**
 * Builder for [VolumeGroup].
 */
@PulumiTagMarker
public class VolumeGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeGroupArgs = VolumeGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeGroupArgsBuilder.() -> Unit) {
        val builder = VolumeGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VolumeGroup {
        val builtJavaResource = com.pulumi.azurenative.netapp.VolumeGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VolumeGroup(builtJavaResource)
    }
}

/**
 * Volume group resource for create
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2021-10-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01, 2023-07-01-preview, 2023-11-01.
 * ## Example Usage
 * ### VolumeGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeGroup = new AzureNative.NetApp.VolumeGroup("volumeGroup", new()
 *     {
 *         AccountName = "account1",
 *         GroupMetaData = new AzureNative.NetApp.Inputs.VolumeGroupMetaDataArgs
 *         {
 *             ApplicationIdentifier = "DEV",
 *             ApplicationType = AzureNative.NetApp.ApplicationType.SAP_HANA,
 *             DeploymentSpecId = "20542149-bfca-5618-1879-9863dc6767f1",
 *             GroupDescription = "Volume group",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "myRG",
 *         VolumeGroupName = "group1",
 *         Volumes = new[]
 *         {
 *             new AzureNative.NetApp.Inputs.VolumeGroupVolumePropertiesArgs
 *             {
 *                 CapacityPoolResourceId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1",
 *                 CreationToken = "test-data-mnt00001",
 *                 Name = "test-data-mnt00001",
 *                 ProximityPlacementGroup = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg",
 *                 ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *                 SubnetId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *                 ThroughputMibps = 10,
 *                 UsageThreshold = 107374182400,
 *                 VolumeSpecName = "data",
 *             },
 *             new AzureNative.NetApp.Inputs.VolumeGroupVolumePropertiesArgs
 *             {
 *                 CapacityPoolResourceId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1",
 *                 CreationToken = "test-log-mnt00001",
 *                 Name = "test-log-mnt00001",
 *                 ProximityPlacementGroup = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg",
 *                 ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *                 SubnetId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *                 ThroughputMibps = 10,
 *                 UsageThreshold = 107374182400,
 *                 VolumeSpecName = "log",
 *             },
 *             new AzureNative.NetApp.Inputs.VolumeGroupVolumePropertiesArgs
 *             {
 *                 CapacityPoolResourceId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1",
 *                 CreationToken = "test-shared",
 *                 Name = "test-shared",
 *                 ProximityPlacementGroup = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg",
 *                 ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *                 SubnetId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *                 ThroughputMibps = 10,
 *                 UsageThreshold = 107374182400,
 *                 VolumeSpecName = "shared",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewVolumeGroup(ctx, "volumeGroup", &netapp.VolumeGroupArgs{
 * 			AccountName: pulumi.String("account1"),
 * 			GroupMetaData: &netapp.VolumeGroupMetaDataArgs{
 * 				ApplicationIdentifier: pulumi.String("DEV"),
 * 				ApplicationType:       pulumi.String(netapp.ApplicationType_SAP_HANA),
 * 				DeploymentSpecId:      pulumi.String("20542149-bfca-5618-1879-9863dc6767f1"),
 * 				GroupDescription:      pulumi.String("Volume group"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			VolumeGroupName:   pulumi.String("group1"),
 * 			Volumes: netapp.VolumeGroupVolumePropertiesArray{
 * 				&netapp.VolumeGroupVolumePropertiesArgs{
 * 					CapacityPoolResourceId:  pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
 * 					CreationToken:           pulumi.String("test-data-mnt00001"),
 * 					Name:                    pulumi.String("test-data-mnt00001"),
 * 					ProximityPlacementGroup: pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
 * 					ServiceLevel:            pulumi.String(netapp.ServiceLevelPremium),
 * 					SubnetId:                pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 					ThroughputMibps:         pulumi.Float64(10),
 * 					UsageThreshold:          pulumi.Float64(107374182400),
 * 					VolumeSpecName:          pulumi.String("data"),
 * 				},
 * 				&netapp.VolumeGroupVolumePropertiesArgs{
 * 					CapacityPoolResourceId:  pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
 * 					CreationToken:           pulumi.String("test-log-mnt00001"),
 * 					Name:                    pulumi.String("test-log-mnt00001"),
 * 					ProximityPlacementGroup: pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
 * 					ServiceLevel:            pulumi.String(netapp.ServiceLevelPremium),
 * 					SubnetId:                pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 					ThroughputMibps:         pulumi.Float64(10),
 * 					UsageThreshold:          pulumi.Float64(107374182400),
 * 					VolumeSpecName:          pulumi.String("log"),
 * 				},
 * 				&netapp.VolumeGroupVolumePropertiesArgs{
 * 					CapacityPoolResourceId:  pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
 * 					CreationToken:           pulumi.String("test-shared"),
 * 					Name:                    pulumi.String("test-shared"),
 * 					ProximityPlacementGroup: pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
 * 					ServiceLevel:            pulumi.String(netapp.ServiceLevelPremium),
 * 					SubnetId:                pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 					ThroughputMibps:         pulumi.Float64(10),
 * 					UsageThreshold:          pulumi.Float64(107374182400),
 * 					VolumeSpecName:          pulumi.String("shared"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.VolumeGroup;
 * import com.pulumi.azurenative.netapp.VolumeGroupArgs;
 * import com.pulumi.azurenative.netapp.inputs.VolumeGroupMetaDataArgs;
 * import com.pulumi.azurenative.netapp.inputs.VolumeGroupVolumePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeGroup = new VolumeGroup("volumeGroup", VolumeGroupArgs.builder()
 *             .accountName("account1")
 *             .groupMetaData(VolumeGroupMetaDataArgs.builder()
 *                 .applicationIdentifier("DEV")
 *                 .applicationType("SAP-HANA")
 *                 .deploymentSpecId("20542149-bfca-5618-1879-9863dc6767f1")
 *                 .groupDescription("Volume group")
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("myRG")
 *             .volumeGroupName("group1")
 *             .volumes(
 *                 VolumeGroupVolumePropertiesArgs.builder()
 *                     .capacityPoolResourceId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1")
 *                     .creationToken("test-data-mnt00001")
 *                     .name("test-data-mnt00001")
 *                     .proximityPlacementGroup("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg")
 *                     .serviceLevel("Premium")
 *                     .subnetId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *                     .throughputMibps(10)
 *                     .usageThreshold(107374182400)
 *                     .volumeSpecName("data")
 *                     .build(),
 *                 VolumeGroupVolumePropertiesArgs.builder()
 *                     .capacityPoolResourceId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1")
 *                     .creationToken("test-log-mnt00001")
 *                     .name("test-log-mnt00001")
 *                     .proximityPlacementGroup("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg")
 *                     .serviceLevel("Premium")
 *                     .subnetId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *                     .throughputMibps(10)
 *                     .usageThreshold(107374182400)
 *                     .volumeSpecName("log")
 *                     .build(),
 *                 VolumeGroupVolumePropertiesArgs.builder()
 *                     .capacityPoolResourceId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1")
 *                     .creationToken("test-shared")
 *                     .name("test-shared")
 *                     .proximityPlacementGroup("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg")
 *                     .serviceLevel("Premium")
 *                     .subnetId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *                     .throughputMibps(10)
 *                     .usageThreshold(107374182400)
 *                     .volumeSpecName("shared")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:VolumeGroup group1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/volumeGroups/{volumeGroupName}
 * ```
 */
public class VolumeGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.VolumeGroup,
) : KotlinCustomResource(javaResource, VolumeGroupMapper) {
    /**
     * Volume group details
     */
    public val groupMetaData: Output<VolumeGroupMetaDataResponse>?
        get() = javaResource.groupMetaData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> volumeGroupMetaDataResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of volumes from group
     */
    public val volumes: Output<List<VolumeGroupVolumePropertiesResponse>>?
        get() = javaResource.volumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> volumeGroupVolumePropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object VolumeGroupMapper : ResourceMapper<VolumeGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.VolumeGroup::class == javaResource::class

    override fun map(javaResource: Resource): VolumeGroup = VolumeGroup(
        javaResource as
            com.pulumi.azurenative.netapp.VolumeGroup,
    )
}

/**
 * @see [VolumeGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VolumeGroup].
 */
public suspend fun volumeGroup(name: String, block: suspend VolumeGroupResourceBuilder.() -> Unit): VolumeGroup {
    val builder = VolumeGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VolumeGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volumeGroup(name: String): VolumeGroup {
    val builder = VolumeGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
