@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.VolumeGroupArgs.builder
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumeGroupMetaDataArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumeGroupMetaDataArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumeGroupVolumePropertiesArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumeGroupVolumePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Volume group resource for create
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2021-10-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01, 2023-07-01-preview, 2023-11-01.
 * ## Example Usage
 * ### VolumeGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeGroup = new AzureNative.NetApp.VolumeGroup("volumeGroup", new()
 *     {
 *         AccountName = "account1",
 *         GroupMetaData = new AzureNative.NetApp.Inputs.VolumeGroupMetaDataArgs
 *         {
 *             ApplicationIdentifier = "DEV",
 *             ApplicationType = AzureNative.NetApp.ApplicationType.SAP_HANA,
 *             DeploymentSpecId = "20542149-bfca-5618-1879-9863dc6767f1",
 *             GroupDescription = "Volume group",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "myRG",
 *         VolumeGroupName = "group1",
 *         Volumes = new[]
 *         {
 *             new AzureNative.NetApp.Inputs.VolumeGroupVolumePropertiesArgs
 *             {
 *                 CapacityPoolResourceId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1",
 *                 CreationToken = "test-data-mnt00001",
 *                 Name = "test-data-mnt00001",
 *                 ProximityPlacementGroup = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg",
 *                 ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *                 SubnetId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *                 ThroughputMibps = 10,
 *                 UsageThreshold = 107374182400,
 *                 VolumeSpecName = "data",
 *             },
 *             new AzureNative.NetApp.Inputs.VolumeGroupVolumePropertiesArgs
 *             {
 *                 CapacityPoolResourceId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1",
 *                 CreationToken = "test-log-mnt00001",
 *                 Name = "test-log-mnt00001",
 *                 ProximityPlacementGroup = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg",
 *                 ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *                 SubnetId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *                 ThroughputMibps = 10,
 *                 UsageThreshold = 107374182400,
 *                 VolumeSpecName = "log",
 *             },
 *             new AzureNative.NetApp.Inputs.VolumeGroupVolumePropertiesArgs
 *             {
 *                 CapacityPoolResourceId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1",
 *                 CreationToken = "test-shared",
 *                 Name = "test-shared",
 *                 ProximityPlacementGroup = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg",
 *                 ServiceLevel = AzureNative.NetApp.ServiceLevel.Premium,
 *                 SubnetId = "/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *                 ThroughputMibps = 10,
 *                 UsageThreshold = 107374182400,
 *                 VolumeSpecName = "shared",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewVolumeGroup(ctx, "volumeGroup", &netapp.VolumeGroupArgs{
 * 			AccountName: pulumi.String("account1"),
 * 			GroupMetaData: &netapp.VolumeGroupMetaDataArgs{
 * 				ApplicationIdentifier: pulumi.String("DEV"),
 * 				ApplicationType:       pulumi.String(netapp.ApplicationType_SAP_HANA),
 * 				DeploymentSpecId:      pulumi.String("20542149-bfca-5618-1879-9863dc6767f1"),
 * 				GroupDescription:      pulumi.String("Volume group"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			VolumeGroupName:   pulumi.String("group1"),
 * 			Volumes: netapp.VolumeGroupVolumePropertiesArray{
 * 				&netapp.VolumeGroupVolumePropertiesArgs{
 * 					CapacityPoolResourceId:  pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
 * 					CreationToken:           pulumi.String("test-data-mnt00001"),
 * 					Name:                    pulumi.String("test-data-mnt00001"),
 * 					ProximityPlacementGroup: pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
 * 					ServiceLevel:            pulumi.String(netapp.ServiceLevelPremium),
 * 					SubnetId:                pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 					ThroughputMibps:         pulumi.Float64(10),
 * 					UsageThreshold:          pulumi.Float64(107374182400),
 * 					VolumeSpecName:          pulumi.String("data"),
 * 				},
 * 				&netapp.VolumeGroupVolumePropertiesArgs{
 * 					CapacityPoolResourceId:  pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
 * 					CreationToken:           pulumi.String("test-log-mnt00001"),
 * 					Name:                    pulumi.String("test-log-mnt00001"),
 * 					ProximityPlacementGroup: pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
 * 					ServiceLevel:            pulumi.String(netapp.ServiceLevelPremium),
 * 					SubnetId:                pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 					ThroughputMibps:         pulumi.Float64(10),
 * 					UsageThreshold:          pulumi.Float64(107374182400),
 * 					VolumeSpecName:          pulumi.String("log"),
 * 				},
 * 				&netapp.VolumeGroupVolumePropertiesArgs{
 * 					CapacityPoolResourceId:  pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
 * 					CreationToken:           pulumi.String("test-shared"),
 * 					Name:                    pulumi.String("test-shared"),
 * 					ProximityPlacementGroup: pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
 * 					ServiceLevel:            pulumi.String(netapp.ServiceLevelPremium),
 * 					SubnetId:                pulumi.String("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 					ThroughputMibps:         pulumi.Float64(10),
 * 					UsageThreshold:          pulumi.Float64(107374182400),
 * 					VolumeSpecName:          pulumi.String("shared"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.VolumeGroup;
 * import com.pulumi.azurenative.netapp.VolumeGroupArgs;
 * import com.pulumi.azurenative.netapp.inputs.VolumeGroupMetaDataArgs;
 * import com.pulumi.azurenative.netapp.inputs.VolumeGroupVolumePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeGroup = new VolumeGroup("volumeGroup", VolumeGroupArgs.builder()
 *             .accountName("account1")
 *             .groupMetaData(VolumeGroupMetaDataArgs.builder()
 *                 .applicationIdentifier("DEV")
 *                 .applicationType("SAP-HANA")
 *                 .deploymentSpecId("20542149-bfca-5618-1879-9863dc6767f1")
 *                 .groupDescription("Volume group")
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("myRG")
 *             .volumeGroupName("group1")
 *             .volumes(
 *                 VolumeGroupVolumePropertiesArgs.builder()
 *                     .capacityPoolResourceId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1")
 *                     .creationToken("test-data-mnt00001")
 *                     .name("test-data-mnt00001")
 *                     .proximityPlacementGroup("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg")
 *                     .serviceLevel("Premium")
 *                     .subnetId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *                     .throughputMibps(10)
 *                     .usageThreshold(107374182400)
 *                     .volumeSpecName("data")
 *                     .build(),
 *                 VolumeGroupVolumePropertiesArgs.builder()
 *                     .capacityPoolResourceId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1")
 *                     .creationToken("test-log-mnt00001")
 *                     .name("test-log-mnt00001")
 *                     .proximityPlacementGroup("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg")
 *                     .serviceLevel("Premium")
 *                     .subnetId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *                     .throughputMibps(10)
 *                     .usageThreshold(107374182400)
 *                     .volumeSpecName("log")
 *                     .build(),
 *                 VolumeGroupVolumePropertiesArgs.builder()
 *                     .capacityPoolResourceId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1")
 *                     .creationToken("test-shared")
 *                     .name("test-shared")
 *                     .proximityPlacementGroup("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg")
 *                     .serviceLevel("Premium")
 *                     .subnetId("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *                     .throughputMibps(10)
 *                     .usageThreshold(107374182400)
 *                     .volumeSpecName("shared")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:VolumeGroup group1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/volumeGroups/{volumeGroupName}
 * ```
 * @property accountName The name of the NetApp account
 * @property groupMetaData Volume group details
 * @property location Resource location
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeGroupName The name of the volumeGroup
 * @property volumes List of volumes from group
 */
public data class VolumeGroupArgs(
    public val accountName: Output<String>? = null,
    public val groupMetaData: Output<VolumeGroupMetaDataArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val volumeGroupName: Output<String>? = null,
    public val volumes: Output<List<VolumeGroupVolumePropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.VolumeGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.VolumeGroupArgs =
        com.pulumi.azurenative.netapp.VolumeGroupArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .groupMetaData(groupMetaData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .volumeGroupName(volumeGroupName?.applyValue({ args0 -> args0 }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VolumeGroupArgs].
 */
@PulumiTagMarker
public class VolumeGroupArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var groupMetaData: Output<VolumeGroupMetaDataArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var volumeGroupName: Output<String>? = null

    private var volumes: Output<List<VolumeGroupVolumePropertiesArgs>>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("uuvprkjassbbdnkv")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Volume group details
     */
    @JvmName("iqksndsagqbrpajp")
    public suspend fun groupMetaData(`value`: Output<VolumeGroupMetaDataArgs>) {
        this.groupMetaData = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("abdufuwlsrgibxtd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tklyervtxirwtkjq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the volumeGroup
     */
    @JvmName("llbigabyliouathl")
    public suspend fun volumeGroupName(`value`: Output<String>) {
        this.volumeGroupName = value
    }

    /**
     * @param value List of volumes from group
     */
    @JvmName("qfvluhxannrnrhye")
    public suspend fun volumes(`value`: Output<List<VolumeGroupVolumePropertiesArgs>>) {
        this.volumes = value
    }

    @JvmName("pemicybirvbqkkom")
    public suspend fun volumes(vararg values: Output<VolumeGroupVolumePropertiesArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values List of volumes from group
     */
    @JvmName("hnluwmkkrdwfsxkp")
    public suspend fun volumes(values: List<Output<VolumeGroupVolumePropertiesArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("ceqoplonnmblcfpa")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Volume group details
     */
    @JvmName("gaddqibldwrsutjr")
    public suspend fun groupMetaData(`value`: VolumeGroupMetaDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupMetaData = mapped
    }

    /**
     * @param argument Volume group details
     */
    @JvmName("wrbtlrswmaftrjmg")
    public suspend fun groupMetaData(argument: suspend VolumeGroupMetaDataArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeGroupMetaDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.groupMetaData = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("qyrxytwjeieiwhwo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fvcauniqigewpbof")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volumeGroup
     */
    @JvmName("mcclohwaviyslwew")
    public suspend fun volumeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeGroupName = mapped
    }

    /**
     * @param value List of volumes from group
     */
    @JvmName("lgnfqmshntbhhpkd")
    public suspend fun volumes(`value`: List<VolumeGroupVolumePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument List of volumes from group
     */
    @JvmName("gtcamphihihytffb")
    public suspend fun volumes(argument: List<suspend VolumeGroupVolumePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VolumeGroupVolumePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument List of volumes from group
     */
    @JvmName("qcdyfiwijkpyyjwt")
    public suspend fun volumes(vararg argument: suspend VolumeGroupVolumePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VolumeGroupVolumePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument List of volumes from group
     */
    @JvmName("ucpgkhrfheensses")
    public suspend fun volumes(argument: suspend VolumeGroupVolumePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VolumeGroupVolumePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values List of volumes from group
     */
    @JvmName("iihqljudkdvdguox")
    public suspend fun volumes(vararg values: VolumeGroupVolumePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): VolumeGroupArgs = VolumeGroupArgs(
        accountName = accountName,
        groupMetaData = groupMetaData,
        location = location,
        resourceGroupName = resourceGroupName,
        volumeGroupName = volumeGroupName,
        volumes = volumes,
    )
}
